% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dynamitefit}
\alias{plot.dynamitefit}
\title{Traceplots and Density Plots for a \code{dynamitefit} Object}
\usage{
\method{plot}{dynamitefit}(x, parameters = NULL, type = NULL, responses = NULL, ...)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{parameters}{[\code{charecter()}]\ Parameter name(s) for which the plots
should be drawn. Possible options can be found with the function
\code{\link[=get_parameter_names]{get_parameter_names()}}. The default is all parameters ofa
specific type for all responses, which can lead to too crowded a plot.}

\item{type}{[\code{character(1)}]\cr Type of the parameter for which the plots
should be drawn. Possible options can be found with the function
\code{\link[=get_parameter_types]{get_parameter_types()}}. Ignored if the argument \code{parameters}
is supplied.}

\item{responses}{[\code{character()}]\cr Response(s) for which the plots should
be drawn. Possible options are \code{unique(x$priors$response)}. Default is
all responses. Ignored if the argument \code{parameters} is supplied.}

\item{...}{Not used..}
}
\value{
A \code{ggplot} object.
}
\description{
Produces the traceplots and the density plots of the model parameters.
}
\examples{
data.table::setDTthreads(1) # For CRAN
plot(gaussian_example_fit, type = "beta")

}
\seealso{
Drawing plots
\code{\link{plot_betas}()},
\code{\link{plot_deltas}()},
\code{\link{plot_lambdas}()},
\code{\link{plot_nus}()},
\code{\link{plot_psis}()}
}
\concept{plotting}
