% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynfrail_fit.R
\name{dynfrail_fit}
\alias{dynfrail_fit}
\title{Inner maximization of the log-likelihood}
\usage{
dynfrail_fit(logfrailtypar, dist, pvfm, Y, Xmat, atrisk, basehaz_line,
  mcox = list(), c_vecs, inner_control, return_loglik = TRUE)
}
\arguments{
\item{logfrailtypar}{A vector containing the natural logarithm of the two parameters (\code{theta} - for the distribution, \code{lambda} - for the autocorrelation)}

\item{dist}{Argument of \code{\link{dynfrail_dist}}}

\item{pvfm}{Argument of \code{\link{dynfrail_dist}}}

\item{Y}{A \code{Surv} object obtained by splitting the original data at all the time points where the frailty process takes new values}

\item{Xmat}{A model matrix obtained by splitting the original data at all the time points where the frailty process takes new values}

\item{atrisk}{A list of various calculations that are used in the maximization process.}

\item{basehaz_line}{A vector with the baseline hazard estimate at each right hand side time point from \code{Y} (can be 0 for the others)}

\item{mcox}{An initial Cox model}

\item{c_vecs}{A list of the length equal to the number of clusters; each element contains a vector of the length of different values that \eqn{Z(t)} takes in that cluster.
Each element of this vector contains the sum of the cumulative hazards associated with that value of the frailty.}

\item{inner_control}{Argument of \code{\link{dynfrail_control}}}

\item{return_loglik}{Logical. If \code{TRUE}, then this just returns the log-likelihood, otherwise it returns also the estimates and information matrix}
}
\value{
The log-likelihood if \code{return_loglik = TRUE} or a list with the log-likelihood and estimates if \code{return_loglik = FALSE}.
}
\description{
Inner maximization of the log-likelihood
}
\details{
This is an internal function that is used by \code{\link{dynfrail}}. It is not recommended to use this directly unless you know exactly what you are doing.
On the other hand, this might be useful if someone wants, for example, to use different maximizers, or to calculate the log-likelihood
at specific values of \code{theta, lambda}. Most of the input can be produced by \code{\link{dynfrail_prep}}.
}
\examples{
arglist1 <- dynfrail_prep(Surv(time, status) ~ rx + sex + cluster(litter),
data = rats)

# using list() inside is because of the way that R converts lists and vectors
mod1 <- do.call(dynfrail_fit, c(logfrailtypar = list(log(c(0.5, 0.1))), arglist1))
}
