% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrCook.R
\name{confint.dynrCook}
\alias{confint.dynrCook}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{dynrCook}(object, parm, level = 0.95,
  type = c("delta.method", "endpoint.transformation"),
  transformation = NULL, ...)
}
\arguments{
\item{object}{a fitted model object}

\item{parm}{which parameters are to be given confidence intervals}

\item{level}{the confidence level}

\item{type}{The type of confidence interval to compute. See details. Partial name matching is used.}

\item{transformation}{For \code{type='endpoint.transformation'} the transformation function used.}

\item{...}{further named arguments. Ignored.}
}
\value{
A matrix with columns giving lower and upper confidence limits for each parameter. These will be labelled as (1-level)/2 and 1 - (1-level)/2 as a percentage (e.g. by default 2.5% and 97.5%).
}
\description{
Confidence Intervals for Model Parameters
}
\details{
The \code{parm} argument can be a numeric vector or a vector of names. If it is missing then it defaults to using all the parameters.

These are Wald-type confidence intervals based on the standard errors of the (transformed) parameters.  Wald-type confidence intervals are known to be inaccurate for variance parameters, particularly when the variance is near zero (See references for issues with Wald-type confidence intervals).
}
\examples{
# Minimal model
require(dynr)

meas <- prep.measurement(
	values.load=matrix(c(1, 0), 1, 2),
	params.load=matrix(c('fixed', 'fixed'), 1, 2),
	state.names=c("Position","Velocity"),
	obs.names=c("y1"))

ecov <- prep.noise(
	values.latent=diag(c(0, 1), 2),
	params.latent=diag(c('fixed', 'dnoise'), 2),
	values.observed=diag(1.5, 1),
	params.observed=diag('mnoise', 1))

initial <- prep.initial(
	values.inistate=c(0, 1),
	params.inistate=c('inipos', 'fixed'),
	values.inicov=diag(1, 2),
	params.inicov=diag('fixed', 2))

dynamics <- prep.matrixDynamics(
	values.dyn=matrix(c(0, -0.1, 1, -0.2), 2, 2),
	params.dyn=matrix(c('fixed', 'spring', 'fixed', 'friction'), 2, 2),
	isContinuousTime=TRUE)

data(Oscillator)
data <- dynr.data(Oscillator, id="id", time="times", observed="y1")

model <- dynr.model(dynamics=dynamics, measurement=meas,
	noise=ecov, initial=initial, data=data)

cook <- dynr.cook(model,
	verbose=FALSE, optimization_flag=FALSE, hessian_flag=FALSE)

# Now get the confidence intervals
# But note that they are nonsense because we set hessian_flag=FALSE !!!!
confint(cook)
}
\references{
Pritikin, J.N., Rappaport, L.M. & Neale, M.C.  (In Press). Likelihood-Based Confidence Intervals for a Parameter With an Upper or Lower Bound.  Structural Equation Modeling.  DOI: 10.1080/10705511.2016.1275969

Neale, M. C. & Miller M. B. (1997). The use of likelihood based confidence intervals in genetic models. Behavior Genetics, 27(2), 113-120.

Pek, J. & Wu, H. (2015). Profile likelihood-based confidence intervals and regions for structural equation models. Psychometrica, 80(4), 1123-1145.

Wu, H. & Neale, M. C. (2012). Adjusted confidence intervals for a bounded parameter. Behavior genetics, 42(6), 886-898.
}

