\name{adjacency.plot}
\alias{adjacency.plot}
\title{
Heatmap plot of the reorganized  adjacency matrices associated to a dynamic stochastic block model.
}
\description{  
Heatmap plot of the adjacency matrices with rows/columns reorganized according to
the group membership  associated to a dynamic stochastic block model.
}
\usage{
adjacency.plot(dynsbm, Y, present=NULL, col=heat.colors(9))
}
\arguments{
  \item{dynsbm}{An object of class \code{dynsbm} retrieved with the function \code{select.dynsbm}.}
  \item{Y}{An object of class \code{array} of dimension (T x N x N) containing T adjacency matrices of size (N x N), where N is the number of nodes in the network and T is the number of time points.}
  \item{present}{\code{NULL} or an object of class \code{matrix} of size (N x T)
    containing the presence/absence (coded with 1/0 respectively) of
    each N nodes at each of the T time points. When set to \code{NULL}, this object is deduced from \code{Y}.}
  \item{col}{A list of colors such as that generated by \code{rainbow}, \code{heat.colors}, \code{topo.colors}, \code{terrain.colors} or similar  functions.}
}
\details{
The T adjacency matrices are represented. The row/lines are reordered following the group membership (nodes of group 1 followed by nodes of group 2 and so on). Red lines correspond to group delineation.
  
The reordering is independent for each time step. The adjacency matrices
do not contain the row/columns corresponding to absent nodes.

If \code{dynsbm} was estimated with \code{edge.type=="binary"}, the
matrices cells are colored in white for value O or in the first color of the
\code{col} argument vector for value 1. If \code{dynsbm} was estimated
with \code{edge.type=="discrete"} or \code{edge.type=="continuous"}, the
matrices cells are colored with a colored gradient for value >0.
}
\references{
Catherine Matias and Vincent Miele, \emph{Statistical clustering of temporal networks through a dynamic stochastic block model}, Journal of the Royal Statistical Society: Series B (2017)
http://dx.doi.org/10.1111/rssb.12200
http://arxiv.org/abs/1506.07464

Vincent Miele and Catherine Matias, \emph{Revealing the hidden structure
  of dynamic ecological networks},  Royal Society Open Science (2017)
http://dx.doi.org/10.1098/rsos.170251
https://arxiv.org/abs/1701.01355
}
\author{
Authors: Catherine Matias, Vincent Miele
  
Maintainer: Vincent Miele <vincent.miele@univ-lyon1.fr>
}
\examples{
####################
## 1 - binary case
data(simdataT5Q4N40binary)

## estimation for Q=1..5 groups
list.dynsbm <- select.dynsbm(simdataT5Q4N40binary, 
				Qmin=1, Qmax=5, edge.type="binary", nstart=1)
				
\dontrun{
## better to use nstart>1 starting points
## but estimation can take 1-2 minutes
list.dynsbm <- select.dynsbm(simdataT5Q4N40binary, 
				Qmin=1, Qmax=5, edge.type="binary", nstart=25)
}

## selection of Q=4
dynsbm <- list.dynsbm[[4]]

## plotting intra/inter connectivity patterns
adjacency.plot(dynsbm, simdataT5Q4N40binary)

####################
## 2 - continuous case
data(simdataT5Q4N40continuous)

## estimation for Q=1..5 groups
list.dynsbm <- select.dynsbm(simdataT5Q4N40continuous, 
				Qmin=1, Qmax=5, edge.type="continuous", nstart=1)
						
\dontrun{
## better to use nstart>1 starting points
## but estimation can take 1-2 minutes
list.dynsbm <- select.dynsbm(simdataT5Q4N40continuous, 
				Qmin=1, Qmax=5, edge.type="continuous", nstart=25)
}

## selection of Q=4
dynsbm <- list.dynsbm[[4]]

## plotting intra/inter connectivity patterns
adjacency.plot(dynsbm, simdataT5Q4N40continuous)

####################
## 3 - discrete case
data(simdataT5Q4N40discrete)

## estimation for Q=1..5 groups
list.dynsbm <- select.dynsbm(simdataT5Q4N40discrete, 
				Qmin=1, Qmax=5, edge.type="discrete", K=4, nstart=1)
									
\dontrun{
## better to use nstart>1 starting points
## but estimation can take 1-2 minutes
list.dynsbm <- select.dynsbm(simdataT5Q4N40discrete, 
				Qmin=1, Qmax=5, edge.type="discrete", K=4, nstart=25)
}

## selection of Q=4
dynsbm <- list.dynsbm[[4]]

## plotting intra/inter connectivity patterns
adjacency.plot(dynsbm, simdataT5Q4N40discrete)
}