% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble.R
\name{extract_row_to_list}
\alias{extract_row_to_list}
\title{Extracts one row from a tibble and converts it to a list}
\usage{
extract_row_to_list(tib, row_id)
}
\arguments{
\item{tib}{the tibble}

\item{row_id}{the index of the row to be selected, or alternatively an expression which will be evaluated to such an index}
}
\value{
the corresponding row from the tibble as a list
}
\description{
Extracts one row from a tibble and converts it to a list
}
\examples{
library(tibble)

tib <- tibble(
  a = c(1, 2),
  b = list(log10, sqrt),
  c = c("parrot", "quest"),
  .object_class = list(c("myobject", "list"), c("yourobject", "list"))
)

extract_row_to_list(tib, 2)
extract_row_to_list(tib, which(a == 1))
}
\seealso{
list_as_tibble tibble_as_list mapdf
}
