% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{lambda}
\alias{lambda}
\title{Create Functions from Formulas/Objects}
\usage{
lambda(x, ...)
}
\arguments{
\item{x}{object to be converted to a function}

\item{...}{arguments passed to methods}
}
\value{
function
}
\description{
\code{lambda} allows the quick creation of anonymous functions from a variety
of different object types, such as formulas or from other calls.
}
\details{
The behavior of \code{lambda} depends on the object that is passed to it.
The method for handling functions returns the function unchanged. The method
for handling symbols evaluates the symbol, then attempts to apply itself to the
result. For calls, \code{lambda} creates a function that applies the new arguments,
along with the original arguments in the call, to the original call function.

\code{lambda} attempts to parse a formula object - an object with syntax \code{LHS ~ RHS} -
by using the value on the left-hand side as the function arguments and the value on
the right-hand side as the function body. The argument on the left-hand side
is split across "." so that multiple arguments can be easily created. For example,
\code{lambda(x.y ~ sqrt(x + y))} creates \code{function(x, y) sqrt(x + y)}.
If the formula is only one-sided, then the formula is parsed similar to the
method in the \code{purrr} package; names that are prefixed by a "." are considered
the function arguments. The previous function could also be created using
\code{lambda(~sqrt(.x + .y))}.

\code{lambda} is used in many of the higher-order functions in the \code{eList}
package. It can also be used in other functions so that users have a variety
of options in which they satisfy functional arguments.
}
\examples{
double2 <- lambda(x.y ~ 2*(x + y))
double2(5, 6)

# alternatively, using 'dot' notation:
double2 <- lambda(~ 2*(.x + .y))

# using a call with partial arguments
subcall <- substitute(round(digits=2))
round2 <- lambda(subcall)
round2(0.04393282)

}
