% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_rescale.R
\name{ensemble_rescale}
\alias{ensemble_rescale}
\title{Rescale SDM predictions}
\usage{
ensemble_rescale(x, x.idx, y, y.abund = NULL, x.var.idx = NULL)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{x.idx}{vector of column names or column indices;
indicates columns in \code{x} with prediction values that will be rescaled}

\item{y}{rescaling method; must be either "abundance" or "sumto1".
See 'Details' section for descriptions of the rescaling methods}

\item{y.abund}{numeric value; ignored if \code{y} is not \code{"abundance"}}

\item{x.var.idx}{vector of column names or column indices;
indicates columns in \code{x} with variance values that will be rescaled.
If \code{x.var.idx} is specified, it must be the same length as \code{x.idx}.
Use \code{x.var.idx = NULL} (the default) if none of the predictions have associated uncertainty values;
see the 'Details' section for more information}
}
\value{
The \code{sf} object \code{x} with the columns specified by \code{x.idx} and \code{x.var.idx} rescaled.
  The \code{agr} attributes of \code{x} will be conserved
}
\description{
Rescale SDM predictions and (if applicable) associated uncertainties
}
\details{
\code{ensemble_rescale} is intended to be used after overlaying predictions with
  \code{\link{overlay_sdm}} and before creating ensembles with \code{\link{ensemble_create}}.
  The provided rescaling methods are:
  \itemize{
    \item'abundance' - Rescale the density values so that the predicted abundance is \code{y.abund}
    \item'sumto1' - Rescale the density values so their sum is 1
  }

  SDM uncertainty values must be rescaled differently than the prediction values.
  Columns specified in \code{x.var.idx} must contain variance values.
  These values will be rescaled using the formula \code{var(c * x) = c^2 * var(x)},
  where \code{c} is the rescaling factor for the associated predictions.

  If \code{x.var.idx} is not \code{NULL}, then the function assumes
  \code{x.var.idx[1]} contains the variance values associated with the predictions in \code{x.idx[1]},
  \code{x.var.idx[2]} contains the variance values associated with the predictions in \code{x.idx[2]}, etc.
  Use \code{NA} in \code{x.var.idx} to indicate a set of predictions that does not have
  associated uncertainty values (e.g., \code{x.var.idx = c(4, NA, 5)})
}
\examples{
ensemble_rescale(preds.1, c("Density", "Density2"), "abundance", 50)
ensemble_rescale(preds.1, c(1, 2), "sumto1")

ensemble_rescale(
  preds.1, c("Density", "Density2"), "abundance", 100, c(3,4)
)


}
