% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProtectTable1.R
\encoding{UTF8}
\name{ProtectTable1}
\alias{ProtectTable1}
\title{Easy input interface to sdcTable}
\usage{
ProtectTable1(data, dimVarInd = 1:NCOL(data), freqVarInd = NULL,
  protectZeros = TRUE, maxN = 3, method = "SIMPLEHEURISTIC",
  findLinked = TRUE, total = "Total", addName = FALSE, sep = ".",
  removeZeros = FALSE, groupVarInd = NULL, ind1 = NULL, ind2 = NULL,
  dimDataReturn = FALSE, ...)
}
\arguments{
\item{data}{Matrix or data frame}

\item{dimVarInd}{Column-indices of the main dimensional variables and additional aggregating variables.}

\item{freqVarInd}{Column-indices of a variable holding counts or NULL in the case of micro data.}

\item{protectZeros}{When TRUE empty cells (count=0) is considered sensitive (i.e. same as allowZeros in primarySuppression).}

\item{maxN}{All cells having counts <= maxN are set as primary suppressed.}

\item{method}{Parameter "method" in protectTable or protectLinkedTables.}

\item{findLinked}{When TRUE, the function may find two linked tables and run protectLinkedTables.}

\item{total}{String used to name totals.}

\item{addName}{When TRUE the variable name is added to the level names, except for variables with most levels.}

\item{sep}{A character string to separate when addName apply.}

\item{removeZeros}{When TRUE, rows with zero count will be removed from the data.}

\item{groupVarInd}{Possible manual specification if list defining the hierarchical variable groups}

\item{ind1}{Coding of table 1 as indices referring to elements of groupVarInd}

\item{ind2}{Coding of table 2 as indices referring to elements of groupVarInd}

\item{dimDataReturn}{When TRUE a data frame containing the dimVarInd variables is retuned}

\item{...}{Further parameters sent to protectTable or protectLinkedTables.}
}
\value{
Output is a list of three elements.

        \strong{table1} consists of the following elements:
        \item{secondary}{Output from protectTable or first element of output from protectLinkedTables.}
        \item{primary}{Output from primarySuppression.}
        \item{problem}{Output from makeProblem.}
        \item{dimList}{Generated input to makeProblem.}
        \item{ind}{Indices referring to elements of groupVarInd in the output element common.}

        \strong{table2} consists of elements of the same type as table1 in cases of two linked tables. Otherwise  table2 is NULL.

        \strong{common} consists of the following elements:
        \item{commonCells}{Input to protectLinkedTables.}
        \item{groupVarInd}{List defining the hierarchical variable groups}
        \item{info}{A table summarizing the tables using variable names}
        \item{nLevels}{The number of levels of each variable (only when groupVarInd input is NULL)}
        \item{dimData}{Data frame containing the dimVarInd variables when dimDataReturn=TRUE. Otherwise NULL.}
}
\description{
protectTable or protectLinkedTables is run with a data set at the only required input.
}
\details{
One or two tables are identified automatically and subjected to cell suppression methods in package sdcTable.
         The tables can alternatively be specified manually by groupVarInd, ind1 and ind2 (see \code{\link{FindTableGroup}}).
}
\examples{
z  <- EasyData("sosialFiktiv")

z8 <- z[z$fylke<=10 & z$kostragr==300,] # 8 regions
a  <- ProtectTable1(z8,c(1,2,4,5),7)
as.data.frame(getInfo(a[[1]][[1]],type="finalData")) # The table (not two linked)

z36 <- z[z$fylke>=11 & z$fylke<=14 & z$kostragr<=500,] # 36 regions
b <- ProtectTable1(z36,1:6,7)
as.data.frame(getInfo(b[[1]][[1]],type="finalData")) # First table
as.data.frame(getInfo(b[[2]][[1]],type="finalData")) # Second table
}
\seealso{
\code{\link{ProtectTable}}, 
        \code{\link{HierarchicalGroups}}, \code{\link{FactorLevCorr}},
        \code{\link{FindDimLists}}, \code{\link{FindCommonCells}}
}

