#' Plot data generated by the `easySimData` package.
#'
#' @param x an object of class `easySimData` returned by `simulateTrialData`.
#' @param ... ignored.
#'
#' @return an object returned by `gridExtra::grid.arrange`, a grid of plots
#' comparing the simulated marginal distribution with the ones specified by
#' users.
#'
#' @export
plot.easySimData <- function(x, ...){

  #cat('Call:\n')
  #print(attr(x, 'call'))
  #cat('\n')

  plots <- list()
  qfuncs <- attr(x, 'quantile_function')
  for(i in seq_along(qfuncs)){
    plots[[i]] <- qqPlot(x[, i], qfuncs[[i]], colnames(x)[i])
  }

  p <-
    grid.arrange(
      grobs = plots,
      left = 'Empirical Quantiles',
      top = 'Q-Q Plots',
      bottom = 'Theoretical Quantiles')

  invisible(p)

}
