% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateequal.R
\name{validate.equal}
\alias{validate.equal}
\title{Validate Equal}
\usage{
validate.equal(
  df1,
  df2,
  id.column = NULL,
  regex.remove = "[^A-z0-9.+\\\\/,-]",
  do.set.NA = TRUE,
  nastrings = easyr::nastrings,
  match.round.to.digits = 4,
  do.all.columns.before.err = FALSE,
  check.column.order = FALSE,
  sort.by.id = TRUE,
  acceptable.pct.rows.diff = 0,
  acceptable.pct.vals.diff = 0,
  return.summary = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{df1}{First data frame or tibble to compare.}

\item{df2}{Second data frame or tibble to compare.}

\item{id.column}{If available, a column to use as an ID. Helpful in various checks and output.}

\item{regex.remove}{Pattern to remove from strings. Used in gsub to remove characters we don't want to consider when comparing values. Set to NULL, NA, or "" to leave strings unchanged.}

\item{do.set.NA}{Remove NA strings.}

\item{nastrings}{Strings to consider NA.}

\item{match.round.to.digits}{Round numbers to these digits before checking equality.}

\item{do.all.columns.before.err}{Check all columns before returning an error. Takes longer but returns more detail. If FALSE, stops at first column that doesn't match and returns mismatches.}

\item{check.column.order}{Enforce same column order.}

\item{sort.by.id}{Sort by the id column before making comparisons.}

\item{acceptable.pct.rows.diff}{If you are OK with differences in a few rows, set this value. If fewer rows in a column don't match, the function will consider the columns equivalent. Iterpreted as a percentage (it gets divided by 100).}

\item{acceptable.pct.vals.diff}{If you are OK with small differences in values, set this value. If the difference in numeric values is less, the function will consider the values equivalent. Iterpreted as a percentage (it gets divided by 100) and compared to absolute value of percentage difference.}

\item{return.summary}{Return 2 items in a list, the row mismatches and a summary of row mismatches.}

\item{verbose}{Print helpful information via cat().}
}
\value{
May return information about mismatches. Otherwise doesn't return anything (NULL).
}
\description{
Check various properties of 2 data frames to ensure they are equivalent.
}
\examples{
validate.equal( iris, iris )

}
