% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atype.R
\name{atype}
\alias{atype}
\title{Auto-Type}
\usage{
atype(
  x,
  auto_convert_dates = TRUE,
  allow_times = FALSE,
  check_numbers = TRUE,
  nazero = FALSE,
  check_logical = TRUE,
  isexcel = TRUE,
  stringsAsFactors = FALSE,
  nastrings = easyr::nastrings,
  exclude = NULL
)
}
\arguments{
\item{x}{Data to auto-type.}

\item{auto_convert_dates}{Choose to convert dates.}

\item{allow_times}{Choose if you want to get times. Only use this if your data has times, otherwise there is a small chance it will prevent proper date conversion.}

\item{check_numbers}{Choose to convert numbers.}

\item{nazero}{Convert NAs in numeric columns to 0.}

\item{check_logical}{Choose to convert numbers.}

\item{isexcel}{By default, we assume this data may have come from excel. This is to assist in date conversion from excel integers. If you know it didn't and are having issues with data conversion, set this to FALSE.}

\item{stringsAsFactors}{Convert strings/characters to factors to save compute time, RAM/memory, and storage space.}

\item{nastrings}{Strings to consider NA.}

\item{exclude}{Column name(s) to exclude.}
}
\value{
Data frame with column types automatically converted.
}
\description{
Use easyr date and number and conversion functions to automatically convert data to the most useful type available.
}
\details{
Author: Bryce Chamberlain.
}
\examples{
# create some data in all-characters.
x = data.frame(
     char = c( 'abc', 'def' ),
     num = c( '1', '2' ),
     date = c( '1/1/2018', '2018-2-01' ),
     na = c( NA, NA ),
     bool = c( 'TRUE', 'FALSE' ),
     stringsAsFactors = FALSE
)

# different atype options. Note how the output types change.
str( atype( x ) )
str( atype( x, exclude = 'date' ) )
str( atype( x, auto_convert_dates = FALSE ) )
str( atype( x, check_logical = FALSE ) )
}
