% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestModels.R
\name{bestEAT}
\alias{bestEAT}
\title{Tuning an Efficiency Analysis Trees model}
\usage{
bestEAT(
  training,
  test,
  x,
  y,
  numStop = 5,
  fold = 5,
  max.depth = NULL,
  max.leaves = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{training}{Training \code{data.frame} or \code{matrix} containing the variables for model construction.}

\item{test}{Test \code{data.frame} or \code{matrix} containing the variables for model assessment.}

\item{x}{Column input indexes in \code{training}.}

\item{y}{Column output indexes in \code{training}.}

\item{numStop}{Set of minimum number of observations in a node for a split to be attempted.}

\item{fold}{Set of number of folds in which the dataset to apply cross-validation during the pruning is divided.}

\item{max.depth}{Depth of the tree.}

\item{max.leaves}{Maximum number of leaf nodes.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
\code{data.frame} in which each row corresponds to a given set of hyperparameters and the root mean squared error (RMSE).
}
\description{
This funcion computes the root mean squared error (RMSE) for an Efficiency Analysis Trees model built with a set of given hyperparameters.
}
\examples{
\donttest{
data("PISAindex")

n <- nrow(PISAindex) # Observations in the dataset
selected <- sample(1:n, n * 0.7) # Training indexes
training <- PISAindex[selected, ] # Training set
test <- PISAindex[-selected, ] # Test set

bestEAT(training = training, 
        test = test,
        x = 6:9,
        y = 3,
        numStop = c(3, 5, 7),
        fold = c(5, 7, 10))
}

}
