% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateExpectedRT.R
\name{calculateExpectedRT}
\alias{calculateExpectedRT}
\title{Calculate Expected Response Times}
\usage{
calculateExpectedRT(lambda, phi = rep(1, length(lambda)), zeta, sdEpsi)
}
\arguments{
\item{lambda}{Vector of time intensity parameters.}

\item{phi}{[optional] Vector of time sensitivity parameters.}

\item{zeta}{Vector of person speed parameters.}

\item{sdEpsi}{Vector of item specific residual variances.}
}
\value{
a matrix, with columns for different \code{zeta} and rows for different items
}
\description{
Calculate expected response times given item parameters of the log normal response time model.
}
\details{
Expected response times are calculated according to the log normal response time model by
van der Linden (2006) or Klein Entink et al. (2009). If \code{phi} is \code{1}, the model
by van der Linden (2006) is used. Either a single set of parameters of vectors of each parameters
can be supplied.

The calculation is based on Fenton (1960). For the model by van der Linden (2006), the calculation was
first introduced by van der Linden (2011).
}
\examples{
# expected RT for a single item (van der Linden model)
calculateExpectedRT(lambda = 3.8, zeta = 0, sdEpsi = 0.3)

# expected RT for multiple items (van der Linden model)
calculateExpectedRT(lambda = c(4.1, 3.8, 3.5), zeta = 0,
                   sdEpsi = c(0.3, 0.4, 0.2))

# TIF for multiple items and multiple ability levels (1PL model)
calculateExpectedRT(lambda = c(3.7, 4.1, 3.8), phi = c(1.1, 0.8, 0.5),
                    zeta = c(-1, 0, 1), sdEpsi = c(0.3, 0.4, 0.2))

}
\references{
Fenton, L. (1960). The sum of log-normal probability distributions in scatter transmission systems. \emph{IRE
Transactions on Communication Systems}, 8, 57-67.

Klein Entink, R. H., Fox, J.-P., & van der Linden, W. J. (2009). A multivariate
multilevel approach to the modeling of accuracy and speed of test
takers. \emph{Psychometrika}, 74(1), 21-48.

van der Linden, W. J. (2006). A lognormal model for response times on test
items. \emph{Journal of Educational and Behavioral Statistics, 31(2),
181-204}.

van der Linden, W. J. (2011). Test design and speededness. \emph{Journal of
Educational Measurement}, 48(1), 44-60.
}
