% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebdm.R
\name{ebdm_estimate}
\alias{ebdm_estimate}
\title{Estimate the Joint Distribution of Two Binary Variables}
\usage{
ebdm_estimate(ni, xi, yi, ci_method = c("none", "normal", "lr"))
}
\arguments{
\item{ni}{Numeric vector. Sample sizes for each dataset.}

\item{xi}{Numeric vector. Count of observations where variable 1 equals 1.}

\item{yi}{Numeric vector. Count of observations where variable 2 equals 1.}

\item{ci_method}{Character string. Method for confidence interval computation.
Options are \code{"none"} (default), \code{"normal"}, or \code{"lr"} (likelihood ratio).}
}
\value{
A named list with point estimates, variance, standard error, and confidence interval (if requested).
\describe{
  \item{p1_hat}{Estimated marginal probability for variable 1.}
  \item{p2_hat}{Estimated marginal probability for variable 2.}
  \item{p11_hat}{Estimated joint probability.}
  \item{var_hat}{Estimated variance of \code{p11_hat}.}
  \item{sd_hat}{Standard error of \code{p11_hat}.}
  \item{ci}{Confidence interval for \code{p11_hat}, if requested.}
}
}
\description{
Performs maximum likelihood estimation (MLE) of the joint distribution
of two binary variables using only marginal summary data from multiple studies.
}
\examples{
data(eg_data)
ebdm_estimate(eg_data$ni, eg_data$xi, eg_data$yi, ci_method = "lr")
}
