% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_cont.R
\name{cor_cont}
\alias{cor_cont}
\title{Estimate the Bivariate Normal Distribution from Marginal Summaries}
\usage{
cor_cont(
  n,
  xbar,
  ybar,
  s2x = NULL,
  s2y = NULL,
  method = c("proposed", "weighted"),
  ci_method = c("none", "normal", "lr")
)
}
\arguments{
\item{n}{Numeric vector. Sample size of each study.}

\item{xbar, ybar}{Numeric vectors. Sample means of the two variables.}

\item{s2x, s2y}{Numeric vectors. Sample variances; required for \code{method = "proposed"}.}

\item{method}{Character. \code{"proposed"} uses the proposed MLE method
in the paper; \code{"weighted"} replicates the weighted
mean based method (Baseline) when no variances are available.}

\item{ci_method}{Confidence interval type: \code{"none"}, \code{"normal"},
or \code{"lr"} (likelihood ratio). Only implemented when
\code{method = "proposed"}.}
}
\value{
A list with elements
  \itemize{
    \item \code{mu_x, mu_y} : estimated marginal means
    \item \code{sigma_x, sigma_y} : estimated SDs
    \item \code{rho} : estimated correlation
    \item \code{se} : standard error of \code{rho} (proposed only)
    \item \code{ci} : confidence interval for \code{rho} (if requested)
  }
}
\description{
Estimate the correlation coefficient \eqn{\rho} (and marginal means / SDs)
of two normally-distributed variables using summary-level data from
multiple independent studies.
}
\examples{
data(cont_example)
# Example with full summaries
cor_cont(cont_example$Sample_Size, cont_example$Mean_X, cont_example$Mean_Y,
 cont_example$Variance_X, cont_example$Variance_Y, method = "proposed", ci_method = "lr")

# Only means + n, weighted mean method
cor_cont(cont_example$Sample_Size, cont_example$Mean_X, cont_example$Mean_Y, method = "weighted")
}
