% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-mapping.R
\name{calc_full_extent}
\alias{calc_full_extent}
\title{Calculates spatial extent of non-zero data from Raster* object for plotting}
\usage{
calc_full_extent(x)
}
\arguments{
\item{x}{Raster* object; either full RasterStack or subset.}
}
\value{
raster Extent object
}
\description{
After loading a RasterStack of results, there are lots of NA values
and plots of individual raster layers will display at the full extent of the
study extent. To show an ideal extent, this function trims away 0 and
NA values and checks to make sure it returns a reasonable extent for
plotting. The returned Extent object can then be used for plotting.
}
\examples{
\dontshow{
# simple toy example
r <- raster::raster(nrow = 100, ncol = 100)
r[5025:5075] <- 1
raster::extent(r)
calc_full_extent(r)
}
\donttest{
# download and load example abundance data
sp_path <- ebirdst_download("example_data")
abd <- load_raster("abundance_umean", sp_path)

# calculate full extent
plot_extent <- calc_full_extent(abd)

# plot
raster::plot(abd[[1]], axes = FALSE, ext = plot_extent)
}
}
