% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_config}
\alias{load_config}
\title{Config file loader}
\usage{
load_config(path)
}
\arguments{
\item{path}{character; full path to the directory containing single species
eBird Status and Trends products.}
}
\value{
environment object containing all run parameters.
}
\description{
Internal function used by load_summary(), load_pis(), and load_pds() to get
configuration variables from STEM species run information
(from *_config.RData).
}
\examples{
\donttest{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)
ebirdst:::load_config(sp_path)
}
}
\keyword{internal}
