% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-habitat.R
\name{ebirdst_habitat}
\alias{ebirdst_habitat}
\alias{plot.ebirdst_habitat}
\title{eBird Status and Trends predictive habitat associations}
\usage{
ebirdst_habitat(path, ext, pis = NULL, pds = NULL, stixels = NULL)

\method{plot}{ebirdst_habitat}(x, n_predictors = 15, date_range = c(0, 1), ...)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent over which to
calculate the habitat associations. Note that \strong{temporal component of \code{ext}
is ignored is this function}, habitat associations are always calculated
for the full year.}

\item{pis, pds, stixels}{as an alternative to providing the \code{path} argument
specifying the location of the data package, the data required to calculate
habitat associations can be provided explicitly. PI, PD, and stixel data
frames can provided, which come from the \code{load_pis()}, \code{load_pds()}, and
\code{load_stixels()} functions, respectively. Ignored if \code{path} is provided.
\strong{In most cases, users will want to avoid using these arguments and simply
provide \code{path} instead.}}

\item{x}{\link{ebirdst_habitat} object; habitat relationships as calculated by
\code{\link[=ebirdst_habitat]{ebirdst_habitat()}}.}

\item{n_predictors}{number of predictors to include in the cake plot. The
most important set of predictors will be chosen based on the maximum weekly
importance value across the whole year.}

\item{date_range}{the range of dates for plotting; a 2-element vector of the
start and end dates of the date range, provided either as dates (Date
objects or strings in ISO format "YYYY-MM-DD") or numbers between 0 and 1
representing the fraction of the year. When providing dates as a string,
the year can be omitted (i.e. "MM-DD"). By default the full year of data
are plotted.}

\item{...}{ignored.}
}
\value{
An \code{ebirdst_habitat} object, consisting of a data frame giving the
predictor importance and directionality for each predictor for each week of
the year. The columns are:
\itemize{
\item \code{predictor}: the name of the predictor
\item \code{date}: the week centroid expressed as a continuous value between 0-1.
See \link{ebirdst_weeks} to convert these values to ISO dates.
\item \code{importance}: the relative importance of the predictor, these values are
scaled so they sum to 1 within each week.
\item \code{direction}: the direction of the relationship, either 1 for a positive
relationship, -1 for a negative relationship, or NA when the direction of
the relationship is not significant.
}
}
\description{
Combine the predictor importance (PI) and partial dependence (PD) data to
provide an estimate of the importance and directionality of the land cover
classes (i.e. habitat) used as covariates in the occurrence probability
model. \strong{Note:} This is one of, if not the most, computationally expensive
operations in the package.
}
\details{
The Status and Trends models use both effort (e.g. number of
observers, length of checklist) and habitat (e.g. elevation, percent forest
cover) covariates; for the full list consult \link{ebirdst_predictors}. This
function calculates habitat associations only for the following covariates
that most closely represent metrics of available habitat. In all cases
these are calculated within a 1.5 km radius of each checklist:
\itemize{
\item Land cover: percent of each landcover class
\item Water cover: percent of each watercover class
\item Intertidal: percent cover of intertidal mudflats
\item Nighttime lights: total refelctance of nighttime lights
\item Roads: road density. There are 5 covariates distinguishing between
different road types; however, these are grouped together for the sake of
the habitat associations.
}

The \code{plot()} method can be used to produce a cake plot, a stacked area chart
showing habitat associations in which area indicates the importance of a
given land cover class and the position above or below the x-axis indicates
the direction of the relationship.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# define a spatial extent to calculate ppms over
bb_vec <- c(xmin = -86, xmax = -83, ymin = 42.5, ymax = 44.5)
e <- ebirdst_extent(bb_vec)

# compute habitat associations
habitat <- ebirdst_habitat(path = path, ext = e)
print(habitat)
# produce a cake plot
plot(habitat)
}
}
