% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_mstate.R
\name{probtrans_mstate}
\alias{probtrans_mstate}
\alias{probtrans_mstate.default}
\alias{probtrans_mstate.coxrfx}
\title{Compute subject-specific or overall transition probabilities}
\usage{
probtrans_mstate(object, ...)

\method{probtrans_mstate}{default}(
  object,
  predt,
  direction = c("forward", "fixedhorizon"),
  method = c("aalen", "greenwood"),
  variance = TRUE,
  covariance = FALSE,
  ...
)

\method{probtrans_mstate}{coxrfx}(object, predt, direction = c("forward", "fixedhorizon"), ...)
}
\arguments{
\item{object}{An msfit object containing estimated cumulative hazards
for each of the transitions in the multi-state model and,
if standard errors are requested, (co)variances of these cumulative hazards
for each pair of transitions.}

\item{...}{other arguments.}

\item{predt}{A positive number indicating the prediction time. 
This is either the time at which the prediction is made (if direction= "forward") 
or the time for which the prediction is to be made (if direction="fixedhorizon").}

\item{direction}{One of "forward" (default) or "fixedhorizon", indicating whether
prediction is forward or for a fixed horizon.}

\item{method}{A character string specifying the type of variances to be computed
(so only needed if either variance or covariance is TRUE). Possible values are 
"aalen" or "greenwood".}

\item{variance}{Logical value indicating whether standard errors are to be
calculated (default is TRUE).}

\item{covariance}{Logical value indicating whether covariances of transition
probabilities for different states are to be calculated (default is FALSE).}
}
\value{
An object of class \code{probtrans}. See the `value' section in the
the help page of \code{\link{probtrans}} for details.
}
\description{
This function is a wrapper for \code{mstate::probtrans}. Its purpose is to 
preclude the computation of (co-)variances of the transition probability 
estimator when the fitted Cox model is empirical Bayes. 
This help page is an adaptation of the \code{mstate::probtrans} help page.
}
\details{
\code{probtrans_mstate} computes estimates of transition probabilities
for an object generated by \code{msfit_generic}. It calls the method 
\code{probtrans_mstate.coxrfx}, if the msfit object was generated
by msfit_generic.coxrfx, or the method probtrans_mstate.default otherwise.
Both methods are identical to the function \code{mstate::probtrans}. The 
only reserve is that \code{probtrans_mstate.coxrfx} does not allow the computation of
the (co-)variances of the transition probability estimator. In fact,
this computation relies on asymptotic results for the \emph{fixed} effects Cox model
(see de Wreede et al, 2010, section 2.3.2), and \code{msfit_generic.coxrfx} produces
estimates of cumulative hazards under a random effects/empirical Bayes Cox model. 

\code{probtrans_mstate} should only be used for Markov models, as it relies
on product limit calculations.
}
\references{
de Wreede LC, Fiocco M, and Putter H (2010). The mstate package for 
estimation and prediction in non- and semi-parametric multi-state and 
competing risks models. \emph{Computer Methods and Programs in Biomedicine} 
\strong{99}, 261–274.
}
\seealso{
\code{\link[mstate:probtrans]{mstate::probtrans}}; \code{\link[mstate:msfit]{mstate::msfit}}; \code{\link{msfit_generic}}.
}
\author{
Rui Costa, adapting the work of L. de Wreede,
M. Fiocco and H. Putter in the
\code{\link{mstate}} package.
}
