% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_fns.R
\name{ebnm_normal_scale_mixture}
\alias{ebnm_normal_scale_mixture}
\title{Solve the EBNM problem using scale mixtures of normals}
\usage{
ebnm_normal_scale_mixture(
  x,
  s = 1,
  mode = 0,
  scale = "estimate",
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default(),
  control = NULL,
  ...
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{mode}{A scalar specifying the mode of the prior \eqn{g} or
\code{"estimate"} if the mode is to be estimated from the data.}

\item{scale}{The nonparametric family of scale mixtures of normals is
approximated via a finite mixture of normal distributions
\deqn{\pi_1 N(\mu, \sigma_1^2) + \ldots + \pi_K N(\mu, \sigma_K^2),}
where parameters \eqn{\pi_k} are estimated and the grid of standard
deviations \eqn{(\sigma_1, \ldots, \sigma_K)} is fixed in advance. By
making the grid sufficiently dense, one can obtain an arbitrarily good
approximation. The grid can be specified by the user via parameter
\code{scale}, in which case the argument should be the vector of
standard deviations \eqn{(\sigma_1, \ldots, \sigma_K)}; alternatively,
if \code{scale = "estimate"}, then
\code{ebnm} sets the grid via function \code{\link{ebnm_scale_normalmix}}.
Note that \code{ebnm} sets the grid differently from
function \code{\link[ashr]{ash}}. To use the \code{ash} grid, set
\code{scale = "estimate"} and pass in \code{gridmult} as an additional
parameter. See \code{\link[ashr]{ash}} for defaults and details.}

\item{g_init}{The prior distribution \eqn{g}. Usually this is left
unspecified (\code{NULL}) and estimated from the data. However, it can be
used in conjuction with \code{fix_g = TRUE} to fix the prior (useful, for
example, to do computations with the "true" \eqn{g} in simulations). If
\code{g_init} is specified but \code{fix_g = FALSE}, \code{g_init}
specifies the initial value of \eqn{g} used during optimization. This has
the side effect of fixing the \code{mode} and \code{scale} parameters. When
supplied, \code{g_init} should be an object of class
\code{\link[ashr]{normalmix}} or an \code{ebnm} object in which the fitted
prior is an object of class \code{normalmix}.}

\item{fix_g}{If \code{TRUE}, fix the prior \eqn{g} at \code{g_init} instead
of estimating it.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}

\item{control}{A list of control parameters to be passed to optimization
function \code{\link[mixsqp]{mixsqp}}.}

\item{...}{When parameter \code{gridmult} is set, an
\code{\link[ashr]{ash}}-style grid will be used instead of the default
\code{ebnm} grid (see parameter \code{scale} above). Other additional
parameters are ignored.}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}}.}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. The sampler takes a single
        parameter \code{nsamp}, the number of posterior samples to return per
        observation.}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem using the family of
  scale mixtures of normals. Identical to function \code{\link{ebnm}}
  with argument \code{prior_family = "normal_scale_mixture"}. For details
  about the model, see \code{\link{ebnm}}.
}
\seealso{
See \code{\link{ebnm}} for examples of usage and model details.

  Available S3 methods include \code{\link{coef.ebnm}},
  \code{\link{confint.ebnm}},
  \code{\link{fitted.ebnm}}, \code{\link{logLik.ebnm}},
  \code{\link{nobs.ebnm}}, \code{\link{plot.ebnm}},
  \code{\link{predict.ebnm}}, \code{\link{print.ebnm}},
  \code{\link{print.summary.ebnm}}, \code{\link{quantile.ebnm}},
  \code{\link{residuals.ebnm}}, \code{\link{simulate.ebnm}},
  \code{\link{summary.ebnm}}, and \code{\link{vcov.ebnm}}.
}
