% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-ts-lag-stats-method.R
\name{ecd.ts_lag_stats}
\alias{ecd.ts_lag_stats}
\title{Lag statistics on timeseries of log returns}
\usage{
ecd.ts_lag_stats(ts = "dji", lags, absolute = FALSE)
}
\arguments{
\item{ts}{the xts object from sample data. The ts must have the logr column.
If a string is given, it will be replaced with sample data of the symbol.}

\item{lags}{a numeric vector of integers greater than 0.}

\item{absolute}{logical, if \code{TRUE}, statistics calculated on absolute log returns. 
Default: \code{FALSE}.}
}
\value{
The xts object containing \code{lagstats} attribute
}
\description{
Lag statistics on log returns are added to the xts attributes. It takes
a vector of lags and calculates the mean, stdev, var, skewness, and kurtosis
for cumulative log returns of each lag. The data is stored as a list of vectors 
under \code{lagstats} attribute. Be aware this function uses multicore lapply.
}
\examples{
\dontrun{
dji <- ecd.ts_lag_stats(ecd.data("dji"), 2)
}
}
\keyword{sample-data}
\keyword{statistics}

