% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-get-ld-triple-method.R
\name{ecop.get_ld_triple}
\alias{ecop.get_ld_triple}
\title{Get triple list of ecld objects by stdev}
\usage{
ecop.get_ld_triple(lambda = 3, sd = 1, beta = 0, mu_plus_ratio = 0,
  epsilon_ratio = 0, atm_imp_k = NaN, fn_shift = NULL)
}
\arguments{
\item{lambda}{numeric, the lambda parameter. Must be positive. Default: 3.}

\item{sd}{numeric, the stdev parameter. Must be positive. Default: 1.}

\item{beta}{numeric, the skewness parameter. Default: 0.}

\item{mu_plus_ratio}{numeric, numeric, excess value in addition to \code{mu_D},
relative to the stdev. Default: 0.}

\item{epsilon_ratio}{numeric, epsilon ratio relative to the stdev. Default: 0.}

\item{atm_imp_k}{numeric, ATM implied log-strike. It is derived from ATM volatility
times sqare root of time to expiration. If provided, it is used to calculate
the fixed point shift, -(atm_imp_k - mu). Default: NaN.
the rho slot in ld1 is populated with the value.}

\item{fn_shift}{function, takes an ecld object and return the fixed point shift, -(atm_imp_k - mu).
the rho slot in ld1 is populated with the value from this function.
This serves as secondary method if you don't want to provide atm_imp_k directly.}
}
\value{
a triple list of ecld objects.
ld0 has mu=0 as vanila object; ld1 has mu and rho as prescribed; ld2 has mu=mu_D.
}
\description{
Construct triple list of ecld objects by stdev, with lambda, and ratios related to stdev.
This utility is used primarily in fixed point ATM hypothesis (when simulating VIX option smile).
}
\examples{
lds <- ecop.get_ld_triple(3, 0.1)
ld1 <- lds$ld1
}
\author{
Stephen H-T. Lihn
}
\keyword{constructor}

