% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-constructor.R
\name{ecld}
\alias{ecld}
\alias{ecld.from}
\alias{ecld.validate}
\alias{ecld.quartic}
\alias{ecld.from_sd}
\title{Constructor of ecld class}
\usage{
ecld(
  lambda = 3,
  sigma = 1,
  beta = 0,
  mu = 0,
  epsilon = NaN,
  rho = NaN,
  with.ecd = FALSE,
  with.mu_D = FALSE,
  with.RN = FALSE,
  is.sged = FALSE,
  verbose = FALSE
)

ecld.from(
  object,
  with.ecd = FALSE,
  with.mu_D = FALSE,
  with.RN = FALSE,
  verbose = FALSE
)

ecld.validate(object, sged.allowed = FALSE, sged.only = FALSE)

ecld.quartic(sigma, epsilon, rho, mu_plus_ratio = NaN, mu_plus = NaN)

ecld.from_sd(lambda = 3, sd = 1, beta = 0, mu = 0)
}
\arguments{
\item{lambda}{numeric, the lambda parameter. Must be positive. Default: 3.}

\item{sigma}{numeric, the scale parameter. Must be positive. Default: 1.}

\item{beta}{numeric, the skewness parameter. Default: 0.}

\item{mu}{numeric, the location parameter. Default: 0.}

\item{epsilon}{The supplemental residual premium for lambda transformation.
It is default to NaN in ecld constructor since its meaning is not defined.}

\item{rho}{The supplemental momentum shift for lambda transformation.
It is default to NaN in ecld constructor since its meaning is not defined.}

\item{with.ecd}{logical, also calculate the ecd object, default is \code{FALSE}.}

\item{with.mu_D}{logical, also calculate the ecd risk-neutral drift, default is \code{FALSE}.
If \code{TRUE}, this flag supercedes \code{with.ecd}.
Also \code{mu} must set to zero.}

\item{with.RN}{logical, also calculate the risk-neutral ecd object, default is \code{FALSE}.
If \code{TRUE}, this flag supercedes \code{with.mu_D}.}

\item{is.sged}{logical, if \code{TRUE}, interpret parameters as SGED.}

\item{verbose}{logical, display timing information, for debugging purpose, default is \code{FALSE}.}

\item{object}{an object of ecld class}

\item{sged.allowed}{logical, used in \code{ecld.validate} to indicate if the function allows SGED.}

\item{sged.only}{logical, used in \code{ecld.validate} to indicate if the function is only for SGED.}

\item{mu_plus, mu_plus_ratio}{numeric, excess value in addition to \code{mu_D}.
When ratio is provided, it is relative to the stdev.}

\item{sd}{numeric, the scale parameter expressed in stdev instead of sigma. Internally,
It is converted to sigma via \code{uniroot} on \code{ecld.sd}.
Must be positive. Default: 1.}
}
\value{
an object of ecld class
}
\description{
Construct an \code{\link{ecld-class}} by providing the required parameters.
The default is the standard symmetric cusp distribution.
The default also doesn't calculate any ecd extension.
\code{ecld.from} allows you to pass the parameters from an existing ecd object.
\code{ecld.validate} checks if an object is ecld class.
\code{ecld.quartic} is a convenient constructor designed for quartic distribution.
\code{ecld.from_sd} calculates sigma from a given sd and renders a vanila ecld object.
}
\examples{
ld <- ecld()
ld <- ecld(2, 0.01)
ld <- ecld.from_sd(3, 0.1)
}
\author{
Stephen H-T. Lihn
}
\keyword{constructor}
