% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_title}
\alias{e_title}
\title{Title}
\usage{
e_title(e, text = NULL, subtext = NULL, link = NULL,
  sublink = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{text, subtext}{Title and Subtitle.}

\item{link, sublink}{Title and Subtitle link.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add title.
}
\examples{
quakes \%>\% 
  dplyr::mutate(mag = exp(mag) / 60) \%>\% 
  e_charts(stations) \%>\% 
  e_scatter(depth, mag) \%>\% 
  e_visual_map(min = 3, max = 7) \%>\% 
  e_title("Quakes", "Stations and Magnitude")

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#title}{Additional arguments}
}
