% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapbox}
\alias{mapbox}
\alias{e_mapbox}
\title{Mapbox}
\usage{
e_mapbox(e, token, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{token}{Your mapbox token from \href{https://www.mapbox.com/}{mapbox}.}

\item{...}{Any option.}
}
\description{
Use mapbox.
}
\note{
Mapbox may not work properly in the RSudio console.
}
\examples{
\dontrun{
url <- paste0("https://ecomfe.github.io/echarts-examples/",
              "public/data-gl/asset/data/population.json")
data <- jsonlite::fromJSON(url)
data <- as.data.frame(data)
names(data) <- c("lon", "lat", "value")

data \%>\% 
  e_charts(lon) \%>\% 
  e_mapbox(
    token = "YOUR_MAPBOX_TOKEN",
    style = "mapbox://styles/mapbox/dark-v9"
  ) \%>\% 
  e_bar_3d(lat, value, coord_system = "mapbox") \%>\% 
  e_visual_map()
}

}
\seealso{
\href{http://www.echartsjs.com/option-gl.html#mapbox3D.style}{Official documentation},
\href{https://www.mapbox.com/mapbox-gl-js/api/}{mapbox documentation}
}
