% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{e_graph}
\alias{e_graph}
\alias{e_graph_gl}
\alias{e_graph_nodes}
\alias{e_graph_edges}
\title{Graph}
\usage{
e_graph(e, layout = "force", name = NULL, rm_x = TRUE, rm_y = TRUE, ...)

e_graph_gl(e, layout = "force", name = NULL, rm_x = TRUE, rm_y = TRUE, ...)

e_graph_nodes(
  e,
  nodes,
  names,
  value,
  size,
  category,
  symbol = NULL,
  legend = TRUE
)

e_graph_edges(e, edges, source, target)
}
\arguments{
\item{e}{An \code{echarts4} object as returned by \code{e_charts}.}

\item{layout}{Layout, one of \code{force}, \code{none} or \code{circular}.}

\item{name}{Name of graph.}

\item{rm_x, rm_y}{Whether to remove the x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other parameter.}

\item{nodes}{Data.frame of nodes.}

\item{names}{Names of nodes, unique.}

\item{value}{values of nodes.}

\item{size}{Size of nodes.}

\item{category}{Group of nodes (i.e.: group membership).}

\item{symbol}{Symbols of nodes.}

\item{legend}{Whether to add serie to legend.}

\item{edges}{Data.frame of edges.}

\item{source, target}{Column names of source and target.}
}
\description{
Create a graph.
}
\examples{
value <- rnorm(10, 10, 2)

nodes <- data.frame(
  name = sample(LETTERS, 10),
  value = value,
  size = value,
  symbol = sample(c("circle", "rect", "triangle"), 10, replace = TRUE),
  grp = rep(c("grp1", "grp2"), 5),
  stringsAsFactors = FALSE
)

edges <- data.frame(
  source = sample(nodes$name, 20, replace = TRUE),
  target = sample(nodes$name, 20, replace = TRUE),
  stringsAsFactors = FALSE
)

e_charts() \%>\%
  e_graph() \%>\%
  e_graph_nodes(nodes, name, value, size, grp, symbol) \%>\%
  e_graph_edges(edges, source, target)

# Use graphGL for larger networks
nodes <- data.frame(
  name = paste0(LETTERS, 1:1000),
  value = rnorm(1000, 10, 2),
  size = rnorm(1000, 10, 2),
  grp = rep(c("grp1", "grp2"), 500),
  stringsAsFactors = FALSE
)

edges <- data.frame(
  source = sample(nodes$name, 2000, replace = TRUE),
  target = sample(nodes$name, 2000, replace = TRUE),
  stringsAsFactors = FALSE
)

e_charts() \%>\%
  e_graph_gl() \%>\%
  e_graph_nodes(nodes, name, value, size, grp) \%>\%
  e_graph_edges(edges, source, target)
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-graph}{Additional arguments},
 \code{\link{e_modularity}}
}
