% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.R
\name{e_append1_p}
\alias{e_append1_p}
\alias{e_append1_p_}
\alias{e_append2_p}
\alias{e_append2_p_}
\title{Append Proxy}
\usage{
e_append1_p(proxy, series_index = NULL, data, x, y)

e_append1_p_(proxy, series_index = NULL, data, x, y)

e_append2_p(
  proxy,
  series_index = NULL,
  data,
  x,
  y,
  z,
  scale = NULL,
  symbol_size = 1
)

e_append2_p_(
  proxy,
  series_index = NULL,
  data,
  x,
  y,
  z,
  scale = NULL,
  symbol_size = 1
)
}
\arguments{
\item{proxy}{An echarts4r proxy as returned by \code{\link{echarts4rProxy}}.}

\item{series_index}{Index of serie to append to (starts from 0).}

\item{data}{Data.frame containing data to append.}

\item{x, y, z}{Columns names to plot.}

\item{scale}{A scaling function as passed to \code{\link{e_scatter}}.}

\item{symbol_size}{Multiplier of scaling function as in \code{\link{e_scatter}}.}
}
\description{
Append data dynamically.
}
\details{
Currently not all types of series supported incremental rendering when using appendData.
Only these types of series support it: \code{\link{e_scatter}} and \code{\link{e_line}} of pure echarts, and
\code{\link{e_scatter_3d}}, and \code{\link{e_line_3d}} of echarts-gl.
}
\examples{
\dontrun{
library(shiny)

ui <- fluidPage(
  actionButton("add", "Add Data to y"),
  echarts4rOutput("plot"),
  h4("Brush"),
  verbatimTextOutput("selected"),
  h4("Legend select change"),
  verbatimTextOutput("legend")
)

server <- function(input, output, session) {
  data <- data.frame(x = rnorm(10, 5, 3), y = rnorm(10, 50, 12), z = rnorm(10, 5, 20))

  react <- eventReactive(input$add, {
    set.seed(sample(1:1000, 1))
    data.frame(x = rnorm(10, 5, 2), y = rnorm(10, 50, 10), z = rnorm(10, 5, 20))
  })

  output$plot <- renderEcharts4r({
    data \%>\%
      e_charts(x) \%>\%
      e_scatter(y, z, scale = NULL) \%>\%
      e_scatter(z) \%>\%
      e_brush()
  })

  observeEvent(input$add, {
    echarts4rProxy("plot") \%>\%
      e_append2_p(0, react(), x, y, z)
  })

  output$selected <- renderPrint({
    input$plot_brush
  })

  output$legend <- renderPrint({
    input$plot_legend_change
  })
}

shinyApp(ui, server)
}

}
