% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.timegrp}
\alias{ec.timegrp}
\title{Timeline by groups}
\usage{
ec.timegrp(wt, df = NULL, scol = NULL, xcol = NULL, type = "line", ...)
}
\arguments{
\item{wt}{An \code{echarty} widget as returned by \link{ec.init}}

\item{df}{A grouped data.frame, required}

\item{scol}{Vector of column names(strings) or indexes for series, required}

\item{xcol}{Column name or index for the X-axis. Default (NULL) will set X-axis to consecutive numbers.}

\item{type}{The series type, default is \emph{'line'}}

\item{...}{Additional attributes to series}
}
\value{
A widget with timeline and options added
}
\description{
Helper function to build timeline data for a grouped data.frame
}
\details{
Timeline axisType is set to 'category'. \cr
Option titles are built and displayed, user could remove them later.
}
\examples{

p <- ec.init() \%>\% 
  ec.timegrp(iris \%>\% dplyr::group_by(Species), 
             c('Sepal.Width','Petal.Length'),
             markPoint = list(data=list(list(type='max'),
                                        list(type='min'))) ) 
p$x$opts$legend <- list(list())  # add legend
p

}
