% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.layout}
\alias{ec.layout}
\title{Charts layout}
\usage{
ec.layout(plots, rows = NULL, cols = NULL, width = "xs", title = NULL)
}
\arguments{
\item{plots}{A list of charts}

\item{rows}{Number of rows}

\item{cols}{Number of columns}

\item{width}{Width of columns, one of xs, md, lg}

\item{title}{Title for the set}
}
\value{
A container \code{\link[htmltools]{div}} in rmarkdown, otherwise \code{\link[htmltools]{browsable}}
}
\description{
Set multiple charts in rows/columns format
}
\details{
For 3-4 charts one would use multiple series with a \href{https://echarts.apache.org/en/option.html#grid}{grid}. For greater number of charts \emph{ec.layout} come in handy.
}
\examples{
options(browser = 'firefox')
tmp <- lapply(list('dark','macarons','gray','jazz','dark-mushroom'),
              function(x) cars |> ec.init() |> ec.theme(x) )
ec.layout(tmp, cols=2 )

}
