% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_est_vdm_screen}
\alias{vd_est_vdm_screen}
\title{Estimate volumetric demand model with attribute-based conjunctive screening}
\usage{
vd_est_vdm_screen(
  vd,
  R = 1e+05,
  keep = 10,
  cores = NULL,
  error_dist = "EV1",
  price_screen = TRUE,
  control = list(include_data = TRUE)
)
}
\arguments{
\item{vd}{volumetric demand data (long format)}

\item{R}{draws}

\item{keep}{thinning}

\item{cores}{no of CPU cores to use (default: auto-detect)}

\item{error_dist}{A string defining the error term distribution, 'EV1' or 'Normal' (default: 'EV1')}

\item{price_screen}{A logical, indicating whether price tag screening should be estimated (default: TRUE)}

\item{control}{list containing additional settings}
}
\value{
est ec-draw object (List)
}
\description{
Estimate volumetric demand model with attribute-based conjunctive screening
}
\examples{
data(icecream)
icecream_est <- icecream \%>\% vd_est_vdm_screen(R=10, cores=2)
}
