% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{plot.forecast_esn}
\alias{plot.forecast_esn}
\title{Plot point forecasts and actuals of a trained ESN model.}
\usage{
\method{plot}{forecast_esn}(x, test = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{forecast_esn}.}

\item{test}{Numeric vector. Test data, i.e., out-of-sample actual values.}

\item{...}{Currently not in use.}
}
\value{
Line chart of point forecast and actual values.
}
\description{
Plot point forecasts and actuals of a trained ESN model as line
  chart. Optionally, test data (out-of-sample) can be added to the plot.
}
\examples{
xdata <- as.numeric(AirPassengers)
xmodel <- train_esn(y = xdata)
xfcst <- forecast_esn(xmodel, n_ahead = 12)
plot(xfcst)

}
