% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{u_fisherZ}
\alias{fisherTransform}
\alias{u_fisherZ}
\title{Calculate Fisher's Z Transformation for Correlations}
\usage{
u_fisherZ(n0, cor0, n1, cor1)

fisherTransform(n_1, r1, n_2, r2)
}
\arguments{
\item{n0}{number of unexposed subjects}

\item{cor0}{correlation matrix of unexposed covariate values. Should be
dimension pxp}

\item{n1}{number of exposed subjects}

\item{cor1}{correlation matrix of exposed covariate values. Should be
dimension pxp}

\item{n_1}{number of unexposed subjects}

\item{r1}{correlation for unexposed}

\item{n_2}{number of exposed subjects}

\item{r2}{correlation for exposed}
}
\value{
a pxp matrix of Fisher's Z transformation of correlations
}
\description{
Calculate Fisher's Z transformation for correlations. This can
  be used as an alternative measure of similarity. Used in the
  \code{s_generate_data} function
}
\note{
\code{fisherTransform} is called internally by \code{u_fisherZ} function
}
\examples{
data("simdata")

X = simdata[,c(-1,-2)]
fisherScore <- u_fisherZ(n0 = 100, cor0 = cor(X[1:50,]),
                         n1 = 100, cor1 = cor(X[51:100,]))

dim(fisherScore)

fisherScore[1:5,1:5]
}
\references{
\url{https://en.wikipedia.org/wiki/Fisher_transformation}
}

