% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecmpredict.r
\name{ecmpredict}
\alias{ecmpredict}
\title{Predict using an ecm object}
\usage{
ecmpredict(ecm, newdata, init)
}
\arguments{
\item{ecm}{ecm object used to make predictions}

\item{newdata}{Data frame to on which to predict}

\item{init}{Initial value for prediction}
}
\value{
Numeric predictions on new data based ecm object
}
\description{
Takes an ecm object and uses it to predict based on new data.
}
\details{
Since error correction models only model the change in the target variable, an initial value must be specified.
}
\examples{
data(FedData)

#Rebuilding model1 from ecm example
trn <- FedData[FedData$date<='2015-12-01',]
xeq <- xtr <- trn[c('UnemploymentRate', 'Inflation', 'GDPgrowth')]
model1 <- ecm(trn$FedFundsRate, xeq, xtr)

#Use 2016-01-01 and onwards data as test data to predict
tst <- FedData[FedData$date>='2016-01-01',]

#predict on tst using model1 and initial FedFundsRate
tst$model1Pred <- ecmpredict(model1, tst, tst$FedFundsRate[1])

}

