% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.RETRA}
\alias{summary.RETRA}
\title{Summarize representative trajectories}
\usage{
\method{summary}{RETRA}(object, ...)
}
\arguments{
\item{object}{An object of class \code{RETRA}.}

\item{...}{(not used)}
}
\value{
Data frame with nine columns and one row for each representative trajectory
in \code{object}. The columns in the returned data frame contain the following
information:
\describe{
\item{\code{ID}}{Identifier of the representative trajectories.}
\item{\code{Size}}{Number of states forming each representative trajectory.}
\item{\code{Length}}{Sum of the dissimilarities in \code{d} between every pair of
consecutive states forming the representative trajectories.}
\item{\code{Avg_link}}{Mean value of the dissimilarities between consecutive states
of the representative trajectories that do not belong to the same ecological
trajectory or site (i.e., artificial links).}
\item{\code{Sum_link}}{Sum of the dissimilarities between consecutive states of the
representative trajectories that do not belong to the same ecological trajectory
or site (i.e., artificial links).}
\item{\code{Avg_density}}{Mean value of the number of segments represented by each
segment of the representative trajectory (excluding artificial links).}
\item{\code{Max_density}}{Maximum number of segments represented by at least one of
the segments of the representative trajectory (excluding artificial links).}
\item{\code{Avg_depth}}{Mean value of the k-d tree depths, that is, the number of
partitions of the ordination space until finding a region with \code{minSegs} segments
or less.}
\item{\code{Max_depth}}{Maximum depth in the k-d tree, that is, the number of partitions
of the ordination space until finding a region with \code{minSegs} segments or less.}
}
}
\description{
Summarize the properties of representative trajectories returned by
\code{\link[=retra_edr]{retra_edr()}} or \code{\link[=define_retra]{define_retra()}}
}
\examples{
# Apply RETRA-EDR to identify representative trajectories
d = EDR_data$EDR1$state_dissim
trajectories = EDR_data$EDR1$abundance$traj
states = EDR_data$EDR1$abundance$state
RT <- retra_edr(d = d, trajectories = trajectories, states = states, minSegs = 5)

# Summarize the properties of the representative trajectories in a data frame
summary(RT)

}
\seealso{
\code{\link[=retra_edr]{retra_edr()}} for identifying representative trajectories in EDRs applying
RETRA-EDR.

\code{\link[=define_retra]{define_retra()}} for generating an object of class \code{RETRA} from trajectory
features.
}
