% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statItemList.R
\name{statItemList}
\alias{statItemList}
\title{Item list of statistics}
\usage{
statItemList(
  api_key,
  stat_code,
  format = c("xml", "json"),
  lang = c("kr", "en"),
  count = 1000
)
}
\arguments{
\item{api_key}{A string specifying ECOS API key. Need not be specified if
the key was stored as an environment variable via \code{\link{setKey}} or
.Renviron.}

\item{stat_code}{A string specifying the statistical table code}

\item{format}{A string specifying the file format to process - xml, json}

\item{lang}{A string specifying the language of result value - kr (Korean),
en (English)}

\item{count}{An integer specifying the number of requests}
}
\value{
A data.frame object containing queried information
}
\description{
Item list of statistics
}
\details{
\preformatted{
## Example
statItemList(lang = "en", count = 100, stat_code = "902Y001")
}
}
