% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statSearch.R
\name{statSearch}
\alias{statSearch}
\title{Search conditional statistics}
\usage{
statSearch(
  api_key,
  stat_code,
  item_code1,
  item_code2 = "?",
  item_code3 = "?",
  item_code4 = "?",
  cycle,
  start_time,
  end_time,
  format = c("xml", "json"),
  lang = c("kr", "en"),
  count
)
}
\arguments{
\item{api_key}{A string specifying ECOS API key. Need not be specified if
the key was stored as an environment variable via \code{\link{setKey}} or
.Renviron.}

\item{stat_code}{A string specifying the statistical table code}

\item{item_code1}{A string specifying the statistical item 1 code}

\item{item_code2}{A string specifying the statistical item 2 code}

\item{item_code3}{A string specifying the statistical item 3 code}

\item{item_code4}{A string specifying the statistical item 4 code}

\item{cycle}{A string specifying the cycle (Annual: A, Semi-Annual: S,
Quarterly: Q, Monthly: M, Semi-Monthly: SM, Daily: D)}

\item{start_time}{A string specifying the start date (according to cycle
format: 2015, 2015S1, 2015Q1, 201501, 201501S1, 20150101, etc.)}

\item{end_time}{A string specifying the end date (according to cycle format:
2015, 2015S1, 2015Q1, 201501, 201501S1, 20150101, etc.)}

\item{format}{A string specifying the file format to process - xml, json}

\item{lang}{A string specifying the language of result value - kr (Korean),
en (English)}

\item{count}{An integer specifying the number of requests}
}
\value{
A data.frame object containing queried information
}
\description{
Search conditional statistics
}
\details{
\preformatted{
## Example
statSearch(lang = "en", stat_code = "102Y004", item_code1 = "ABA1", cycle =
"M", start_time = "196001", end_time = "201812")
}
}
