% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa.as-emoa.R
\name{asemoa}
\alias{asemoa}
\title{Implementation of the NSGA-II EMOA algorithm by Deb.}
\usage{
asemoa(task, n.population = 10L, aspiration.set = NULL,
  normalize.fun = NULL, dist.fun = ecr:::computeEuclideanDistance, p = 1,
  parent.selector = setupSimpleSelector(),
  mutator = setupPolynomialMutator(eta = 25, p = 0.2),
  recombinator = setupSBXRecombinator(eta = 15, p = 0.7), max.iter = 100L,
  max.evals = NULL, max.time = NULL, ...)
}
\arguments{
\item{task}{[\code{ecr_optimization_task}]\cr
Optimization task. If a \code{smoof_function} is passed it is automatically
converted into a task.}

\item{n.population}{[\code{integer(1)}]\cr
Population size. Default is \code{10}.}

\item{aspiration.set}{[\code{matrix}]\cr
The aspiration set. Each column contains one point of the set.}

\item{normalize.fun}{[\code{function}]\cr
Function used to normalize fitness values of the individuals
before computation of the average Hausdorff distance.
The function must have the formal arguments \dQuote{set} and \dQuote{aspiration.set}.
Default is \code{NULL}, i.e., no normalization at all.}

\item{dist.fun}{[\code{function}]\cr
Distance function used internally by Hausdorff metric to compute distance
between two points. Expects a single vector of coordinate-wise differences
between points.
Default is \code{computeEuclideanDistance}.}

\item{p}{[\code{numeric(1)}]\cr
Parameter \eqn{p} for the average Hausdorff metric. Default is 1.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations. Default ist \code{100L}.}

\item{max.evals}{[\code{integer(1)}]\cr
Maximal number of iterations/generations. Default is \code{Inf}.}

\item{max.time}{[\code{integer(1)}]\cr
Time budget in seconds. Default ist \code{Inf}.}

\item{...}{[any]\cr
Further arguments passed to \code{\link{setupECRControl}}.}
}
\value{
[\code{ecr_asemoa_result, ecr_multi_objective_result}]
}
\description{
The AS-EMOA, short for aspiration set evolutionary multi-objective
algorithm aims to incorporate expert knowledge into multi-objective optimization [1].
The algorithm expects an aspiration set, i.e., a set of reference points. It
then creates an approximation of the pareto front close to the aspiration set
utilizing the average Hausdorff distance.
}
\note{
This is a pure R implementation of the AS-EMOA algorithm. It hides the regular
\pkg{ecr} interface and offers a more R like interface while still being quite
adaptable.
}
\examples{
library(smoof)

obj.fn = makeDTLZ2Function(dimensions = 2L, n.objectives = 2L)

# define the aspiration set, i.e., a set of reference points
aspiration.set = matrix(
  c(0.1531, 0.1594, 0.1656, 0.1719, 0.1781, 0.1844, 0.1906, 0.1969, 0.2031, 0.2094,
    0.2094, 0.2031, 0.1969, 0.1906, 0.1844, 0.1781, 0.1719, 0.1656, 0.1594, 0.1531),
  byrow = TRUE,
  nrow = 2L
)

\dontrun{
res = asemoa(
  task = obj.fn,
  n.population = 10L,
  aspiration.set = aspiration.set,
  max.evals = 1000L
)
}
}
\references{
[1] Rudolph, G., Schuetze, S., Grimme, C., Trautmann, H: An Aspiration Set
EMOA Based on Averaged Hausdorff Distances. LION 2014: 153-156.
[2] G. Rudolph, O. Schuetze, C. Grimme, and H. Trautmann: A Multiobjective
Evolutionary Algorithm Guided by Averaged Hausdorff Distance to Aspiration
Sets, pp. 261-273 in A.-A. Tantar et al. (eds.): Proceedings of EVOLVE - A
bridge between Probability, Set Oriented Numerics and Evolutionary Computation
V, Springer: Berlin Heidelberg 2014.
}
\keyword{optimize}

