% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_imp}
\alias{plot_imp}
\title{Plot variable importance from random forests}
\usage{
plot_imp(imp, sort = "decreasing")
}
\arguments{
\item{imp}{object of class \code{c("importance", "data.frame")} as returned by
\code{\link{variable_importance}}}

\item{sort}{character indicating if sorting of the output is to be done.
can be "ascending", or "descending."}
}
\value{
a ggplot2 object
}
\description{
Plot variable importance from random forests
}
\examples{
library(randomForest)
data(iris)
fit <- randomForest(Species ~ ., iris)
imp <- variable_importance(fit, nperm = 2, data = iris)
plot_imp(imp)
}

