% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoother_resid.R
\name{smoother_resid}
\alias{smoother_resid}
\title{Residuals of the Smoother}
\usage{
smoother_resid(data, smoother_pts)
}
\arguments{
\item{data}{A data frame in long format containing the data for which events
is to be detected. This means that each measurement corresponds to a row
and the columns are (in order): source (the device or person from which the
data was collected), point in time,
measurement value, lower detection bound, and upper detection bound.

The source is expected to
be a string; the time point, measurements, and detection bounds are expected to be numerical.
The detection bounds are in absolute value in the same unit as the
values and each is expected to be identical for the same source.

In case detection is wanted for a one sided change (e.g. give an event if
the confidence bounds drop below a threshold) then the upper or lower detection
bound can be chosen to be Inf or -Inf respectively.}

\item{smoother_pts}{A data frame containing the smoother. Preferably the
output of one of the smoother functions included in this package.}
}
\value{
A vector of the same length as \code{data} containing the residuals.
}
\description{
Calculate the residuals of the smoother to the data points.
}
