% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filing_information.R
\name{filing_information}
\alias{filing_information}
\alias{filing_information.character}
\alias{filing_information.xml_node}
\title{SEC Filing Information}
\usage{
filing_information(x)

\method{filing_information}{character}(x)

\method{filing_information}{xml_node}(x)
}
\arguments{
\item{x}{URL or xml_document for a SEC filing index page}
}
\value{
A dataframe with all the parsed meta-info on the filing
}
\description{
The SEC generates a html page as an index for every filing it receives containing
all the meta-information about the filing.
}
\details{
Information returned:
\itemize{
 \item type
 \item description
 \item accession_number
 \item filing_date
 \item accepted_date
 \item documents
 \item period_date
 \item changed_date
 \item effective_date
 \item filing_bytes
}
Not all details are valid for all filings, but the column will always be present

If you know you're going to want all the details of a filing, including documents
funds and filers, look at `filing_details`
}
\examples{
# Typically you'd get the URL from one of the search functions
x <- paste0("https://www.sec.gov/Archives/edgar/data/",
            "933691/000119312517247698/0001193125-17-247698-index.htm")
filing_information(x)
}
