% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allot.R
\name{allot}
\alias{allot}
\alias{allot_trts}
\alias{allot_units}
\alias{allot_table}
\title{Define the possible allocation of treatments to units}
\usage{
allot_trts(.edibble, ..., .record = TRUE)

allot_units(.edibble, ..., .record = TRUE)

allot_table(
  .edibble,
  ...,
  order = "random",
  seed = NULL,
  constrain = nesting_structure(.edibble)
)
}
\arguments{
\item{.edibble}{An edibble design (\code{edbl_design}), an edibble data frame (\code{edbl_table}) or an
object that contains the edibble data frame in the attribute
\code{design}.}

\item{...}{One-sided or two-sided formula. If the input is a one-sided formula
then the whole treatment is applied to the specified unit.}

\item{.record}{Whether to record the step.}

\item{order}{A character vector signifying the apportion of treatments to units.
The value should be either "random", "systematic" or "systematic-random".
"random" allocates the treatment randomly to units based on specified allotment with restrictions
implied by unit structure.
"systematic" allocates the treatment in a systematic order to units.
"systematic-random" allocates the treatment in a systematic order to units but
where it is not possible to divide treatments equally (as the number of units are not divisible
by the number of levels of the treatment factor), then the extras are chosen randomly.}

\item{seed}{A scalar value used to set the seed so that the result is reproducible.}

\item{constrain}{The nesting structure for units.}
}
\value{
Return an edibble design.
}
\description{
This function adds the edges between variable nodes to
specify the mapping of units to treatment. This function
does not actually assign specific treatment levels onto actual units.
}
\examples{
design() \%>\%
  set_units(block = 10,
            plot = nested_in(block, 3)) \%>\%
  set_trts(treat = c("A", "B", "C"),
           pest = c("a", "b")) \%>\%
  allot_trts(treat ~ plot,
              pest ~ block)

}
\seealso{
assign

Other user-facing functions: 
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
