library(testthat)

test_that("Checking a data set works",{
   edt <- editmatrix(editrules = "2*x==y")
   dat <- data.frame(x=c(2,1), y=c(4,5))
   #print(checkEdits(dat, edt)) 
   expect_equal(checkRows(edt, dat), c(TRUE,FALSE))
})


test_that("Showing data errors works",{
   edt <- editmatrix(editrules = "2*x==y\n5*x==y")
   dat <- data.frame(x=c(2,1), y=c(4,5))
   errors <- errorMatrix(edt, dat)
   #print(errors)
})


test_that("Error lists works",{
   edt <- editmatrix(editrules = "2*x==y\n5*x==y")
   dat <- data.frame(x=c(2,1), y=c(4,5))
   errors <- listErrors(edt, dat)
   print(errors)
   #print(showErrors(dat, edt)) 
})