% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOutcomeWeights.R
\name{plotOutcomeWeights}
\alias{plotOutcomeWeights}
\title{Visualize the change of connection weights between a specific outcome and all 
cues.}
\usage{
plotOutcomeWeights(
  wmlist,
  outcome,
  select.cues = NULL,
  init.value = 0,
  add.labels = TRUE,
  add = FALSE,
  ...
)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{outcome}{String: outcome for which to extract the connection weights.}

\item{select.cues}{Optional selection of outcomes to limit the number 
of connection weights that are returned. The value of NULL (default) will 
return all connection weights. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use \code{\link{getOutcomes}} for returning all outcomes from the 
data, and \code{\link{getValues}} for returning all outcomes in the data.}

\item{init.value}{Value of connection weights for non-existing connections. 
Typically set to 0.}

\item{add.labels}{Logical: whether or not to add labels for the lines. 
Defaults to TRUE, see examples.}

\item{add}{Logical: whether or not to add the lines to an existing plot. 
Defaults to FALSE (starting a new plot).}

\item{...}{Optional graphical arguments, as specified in 
\code{\link[graphics]{par}}. These parameters are forwarded to the functions 
\code{\link[plotfunctions]{emptyPlot}}, \code{\link[graphics]{lines}}, and 
\code{\link[graphics]{text}}.}
}
\value{
Optionally a list with label specifications is returned, which 
allows to plot your own labels. This may be helpful for very long labels, 
and for overlapping lines.
}
\description{
Visualize the change of connection weights between a specific 
outcome and all cues.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)
dim(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)

# this training data can actually be used train network:
wm <- RWlearning(train)

# plot connection weights for cue = 'car':
plotOutcomeWeights(wm, outcome="vehicle")


# plot your own labels:
labels <- plotOutcomeWeights(wm, outcome="vehicle", add.labels=FALSE)
legend_margin('topright', legend=labels$labels, col=labels$col, 
    lwd=1, bty='n')

# change color and select outcomes:
out <- getValues(train$Cues, unique=TRUE)
out <- out[! out \%in\% c("car", "bicycle")]
labels <- plotOutcomeWeights(wm, outcome="vehicle", add.labels=FALSE, 
	   ylim=c(-.5,1),col=alpha(1), select.cues=out)
lab2 <- plotOutcomeWeights(wm, outcome="vehicle", add.labels=FALSE, 
    select.cues=c("car", "bicycle"), add=TRUE, col=2, lwd=2, xpd=TRUE)
legend_margin('topright', legend=c(labels$labels, c("car", "bicycle")), 
    col=c(labels$col, lab2$col), lwd=c(labels$lwd, lab2$lwd), 
    lty=c(labels$lty, lab2$lty))

}
\seealso{
\code{\link{plotCueWeights}}, \code{\link{getWeightsByOutcome}}, 
\code{\link{getWeightsByCue}}
}
\author{
Jacolien van Rij
}
