% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npf.R
\name{npf}
\alias{npf}
\title{Nonparametric Position Formulation}
\usage{
npf(
  D,
  A = NA,
  d,
  dmax = (nrow(D) - 1),
  decreaseDim = 1,
  stretch = NULL,
  method = "Linear",
  toler = 1e-08
)
}
\arguments{
\item{D}{An nxn partial-distance matrix to be completed. D must satisfy a list of conditions (see details), with unkown entries set to NA.}

\item{A}{a weight matrix, with \eqn{h_{ij} = 0} implying \eqn{a_{ij}} is unknown. Generally, if \eqn{a_{ij}} is known, \eqn{h_{ij} = 1}, although any non-negative weight is allowed.}

\item{d}{the dimension of the resulting completion}

\item{dmax}{the maximum dimension to consider during dimension relaxation}

\item{decreaseDim}{during dimension reduction, the number of dimensions to decrease each step}

\item{stretch}{should the distance matrix be multiplied by a scalar constant? If no, stretch = NULL, otherwise stretch is a positive scalar}

\item{method}{The method used for dimension reduction, one of "Linear" or "NLP".}

\item{toler}{convergence tolerance for the algorithm}
}
\value{
\item{D}{an nxn matrix of the completed Euclidean distances}
\item{optval}{the minimum value achieved of the target function during minimization}
}
\description{
\code{npf} returns a completed Euclidean Distance Matrix D, with dimension d,
from a partial Euclidean Distance Matrix using the methods of Fang & O'Leary (2012)
}
\details{
This is an implementation of the Nonconvex Position Formulation (npf)
for Euclidean Distance Matrix Completion, as proposed in 'Euclidean 
Distance Matrix Completion Problems' (Fang & O'Leary, 2012).

The method seeks to minimize the following:

\deqn{||A \cdot (D - K(XX'))||_{F}^{2}}

where the function K() is that described in gram2edm, and the norm is Frobenius. Minimization is over X, the nxp matrix of node locations.

The matrix D is a partial-distance matrix, meaning some of its entries are unknown. 
It must satisfy the following conditions in order to be completed:
\itemize{
\item{diag(D) = 0}
\item{If \eqn{a_{ij}} is known, \eqn{a_{ji} = a_{ij}}}
\item{If \eqn{a_{ij}} is unknown, so is \eqn{a_{ji}}}
\item{The graph of D must be connected. If D can be decomposed into two (or more) subgraphs, 
   then the completion of D can be decomposed into two (or more) independent completion problems.}
}
}
\examples{

D <- matrix(c(0,3,4,3,4,3,
             3,0,1,NA,5,NA,
             4,1,0,5,NA,5,
             3,NA,5,0,1,NA,
             4,5,NA,1,0,5,
             3,NA,5,NA,5,0),byrow=TRUE, nrow=6)
             
A <- matrix(c(1,1,1,1,1,1,
             1,1,1,0,1,0,
             1,1,1,1,0,1,
             1,0,1,1,1,0,
             1,1,0,1,1,1,
             1,0,1,0,1,1),byrow=TRUE, nrow=6)

edmc(D, method="npf", d=3, dmax=5)

}
\seealso{
\code{\link{gram2edm}}
}
