% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nat_data_2016}
\alias{nat_data_2016}
\title{Data of the Australian Electorate from 2016}
\format{A data frame with 150 rows with the following variables:
\itemize{
    \item id: numeric identifier that links the electorate with the corresponding polygon in `nat_map`.
    \item Elect_div: Electorate division name   
    \item State: abbreviation of the state name
    \item Numccds: AEC variable that might be filled with meaning or a description down the road
    \item Area_SqKm: combined square kilometers of each electorate
    \item id Numerical id for electorate
    \item long_c Centroid longitude
    \item lat_c Centroid latitude
}}
\usage{
nat_data_2016
}
\description{
A dataset containing some demographic information for each of the 150 Australian electorates.
The data were obtained from the Australian Electoral Commission, and downloaded 
from \url{http://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}.
The data is published
}
\examples{

data(nat_data_2016)
data(nat_map_2016)
library(ggplot2)
library(ggthemes)
ggplot(aes(map_id=id), data=nat_data_2016) +
  geom_map(map=nat_map_2016) +
  geom_point(data=nat_data_2016, aes(x=long_c, y=lat_c), inherit.aes=FALSE) +
  expand_limits(x=nat_map_2016$long, y=nat_map_2016$lat) + 
  theme_map()
  
}
\keyword{datasets}
