% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eefAnalytics_03_2017.r
\name{caceMSTBoot}
\alias{caceMSTBoot}
\title{CACE Analysis of Multisite Randomised Education Trials.}
\usage{
caceMSTBoot(formula, random, intervention, compliance, nBoot, data)
}
\arguments{
\item{formula}{the model to be analysed. It is of the form y ~ x1+x2+.... Where y is the outcome variable and Xs are the predictors.}

\item{random}{a string variable specifying the "clustering variable" as contained in the data. See example below}

\item{intervention}{a string variable specifying the "intervention variable" as appeared in the formula. See example below}

\item{compliance}{a string variable specifying the "compliance variable" as contained in the data. The data must be in percentages ranging from 0 - 100.}

\item{nBoot}{number of bootstraps required to generate bootstrap confidence interval. Default is NULL.}

\item{data}{data frame containing the data to be analysed.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{CACE}. Estimates of CACE adjusted effect sizes based on pre-specified thresholds. Only produced for threshold with at least 50% compliance rate.
\item \code{Compliers}. Percentage of pupils that achieved a pre-specified threshold of compliance.
}
}
\description{
\code{caceMSTBoot} performs exploratory CACE analysis of multisite randomised education trials.
}
\examples{
if(interactive()){

data(mstData)

########################################################
## MLM analysis of multisite trials + 1.96SE ##
########################################################

output1 <- mstFREQ(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",data=mstData)


### Fixed effects
beta <- output1$Beta
beta

### Effect size
ES1 <- output1$ES
ES1

## Covariance matrix
covParm <- output1$covParm
covParm

### plot random effects for schools

plot(output1)

###############################################
## MLM analysis of multisite trials          ##	 
## with bootstrap confidence intervals       ##
###############################################

output2 <- mstFREQ(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",nBoot=1000,data=mstData)

tp <- output2$Bootstrap
### Effect size

ES2 <- output2$ES
ES2

### plot bootstrapped values 

plot(output2, group=1)

#######################################################################
## MLM analysis of mutltisite trials with permutation p-value##
#######################################################################

output3 <- mstFREQ(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",nPerm=1000,data=mstData)

ES3 <- output3$ES
ES3

#### plot permutated values 

plot(output3, group=1)
}
}

