% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eefAnalytics_03_2017.r
\name{caceSRTBoot}
\alias{caceSRTBoot}
\title{CACE Analysis of Simple Randomised Education Trials.}
\usage{
caceSRTBoot(formula, intervention, compliance, nBoot, data)
}
\arguments{
\item{formula}{the model to be analysed. It is of the form y ~ x1+x2+.... Where y is the outcome variable and Xs are the predictors.}

\item{intervention}{a string variable specifying the "intervention variable" as appeared in the formula. See example below}

\item{compliance}{a string variable specifying the "compliance variable" as contained in the data.  The data must be in percentages ranging from 0 - 100.}

\item{nBoot}{number of non-parametric bootstraps.  Default is NULL.}

\item{data}{data frame containing the data to be analysed.}
}
\value{
S3 \code{mcpi} object; a list consisting of
\itemize{
\item \code{CACE}. Estimates of CACE adjusted effect sizes based on pre-specified thresholds. Only produced for threshold with atleast 50% compliance rate.
\item \code{Compliers} Percentage of pupils that achieved a pre-specified threshold of compliance.
}
}
\description{
\code{caceSRTBoot} performs exploraty CACE analysis of simple randomised education trials.
}
\examples{
if(interactive()){

data(mstData)
############# weighted ITT ####################################
caceOutput3<- caceSRTBoot(Posttest~ Prettest+ Intervention,
			intervention="Intervention",
			compliance = "Percentage_Attendance",nBoot=1000,data=mstData)

cace <- caceOutput3$CACE
cace

Complier <- caceOutput3$Compliers
Complier 

### visualising CACE effect size

plot(caceOutput3)
}
}

