% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/remove_char.R
\name{remove_char}
\alias{remove_char}
\title{A function to replace an arbitrary character like a "*" in redacted data with an NA in R}
\usage{
remove_char(x, char)
}
\arguments{
\item{x}{a vector of data that should be numeric but contains characters
indicating redaction forcing R to read it as character}

\item{char}{the character string that should be removed from the vector.}
}
\value{
Returns a vector of the same length as the input vector that is numeric
with NAs in place of the character.
}
\description{
Redacted education data files often have a "*" character.
When importing into R this is a problem, which this function solves in a simple
step by replacing "*" with NA, and then converting the vector to numeric.
}
\note{
Future versions could be modified to accomodate other indicators of
redacted data.
}
\examples{
a <- c(1, 5, 3, 6, "*", 2, 5, "*", "*")
b <- remove_char(a, "*")
as.numeric(b)
}
\author{
Jared E. Knowles
}
\keyword{manip}

