% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_d_to_percentage.R, R/convert_d_to_r.R,
%   R/convert_odds_to_d.R, R/convert_odds_to_probs.R
\name{percentage_to_d}
\alias{percentage_to_d}
\alias{d_to_percentage}
\alias{convert_percentage_to_d}
\alias{convert_d_to_percentage}
\alias{d_to_r}
\alias{r_to_d}
\alias{convert_d_to_r}
\alias{convert_r_to_d}
\alias{odds_to_d}
\alias{convert_odds_to_d}
\alias{logodds_to_d}
\alias{d_to_odds}
\alias{convert_d_to_odds}
\alias{odds_to_r}
\alias{convert_odds_to_r}
\alias{logodds_to_r}
\alias{r_to_odds}
\alias{convert_r_to_odds}
\alias{odds_to_probs}
\alias{odds_to_probs.data.frame}
\alias{probs_to_odds}
\alias{convert_odds_to_probs}
\alias{convert_probs_to_odds}
\title{General effect size conversion}
\usage{
percentage_to_d(percentage, ...)

d_to_percentage(d, ...)

convert_percentage_to_d(percentage, ...)

convert_d_to_percentage(d, ...)

d_to_r(d, ...)

r_to_d(r, ...)

convert_d_to_r(d, ...)

convert_r_to_d(r, ...)

odds_to_d(odds, log = FALSE, ...)

convert_odds_to_d(odds, log = FALSE, ...)

logodds_to_d(odds, log = TRUE, ...)

d_to_odds(d, log = FALSE, ...)

convert_d_to_odds(d, log = FALSE, ...)

odds_to_r(odds, log = FALSE, ...)

convert_odds_to_r(odds, log = FALSE, ...)

logodds_to_r(odds, log = TRUE, ...)

r_to_odds(r, log = FALSE, ...)

convert_r_to_odds(r, log = FALSE, ...)

odds_to_probs(odds, log = FALSE, ...)

\method{odds_to_probs}{data.frame}(odds, log = FALSE, select = NULL, exclude = NULL, ...)

probs_to_odds(probs, log = FALSE, ...)

convert_odds_to_probs(odds, log = FALSE, ...)

convert_probs_to_odds(probs, log = FALSE, ...)
}
\arguments{
\item{percentage}{Percentage value (e.g., \code{0.01} for one percent).}

\item{...}{Arguments passed to or from other methods.}

\item{d}{Standardized difference value (Cohen's d).}

\item{r}{Correlation coefficient r.}

\item{odds}{Odds values in vector or dataframe.}

\item{log}{Take in or output log odds (such as in logistic models).}

\item{select}{When a dataframe is passed, character or list of of column names to be
transformed.}

\item{exclude}{When a dataframe is passed, character or list of column names to be excluded
from transformation.}

\item{probs}{Probability values.}
}
\value{
Converted index.
}
\description{
Enables a conversion between different indices of effect size, such as standardized difference (Cohen's d), correlation r or (log) odds ratios.
}
\details{
\itemize{
\item \emph{d to r}: \eqn{d = \frac{2 * r}{\sqrt{1 - r^2}}}
\item \emph{r to d}: \eqn{r = \frac{d}{\sqrt{d^2 + 4}}}
\item \emph{odds to d}: \eqn{d = \frac{\log(odds)\times\sqrt{3}}{\pi}}
\item \emph{d to odds}: \eqn{log(odds) = d * \frac{\pi}{\sqrt(3)}}
}
}
\examples{
r_to_d(0.5)
d_to_odds(d = 1.154701)
odds_to_r(odds = 8.120534)

d_to_r(d = 1)
r_to_odds(0.4472136, log = TRUE)
odds_to_d(1.813799, log = TRUE)
}
\references{
\itemize{
\item Sánchez-Meca, J., Marín-Martínez, F., & Chacón-Moscoso, S. (2003). Effect-size indices for dichotomized outcomes in meta-analysis. Psychological methods, 8(4), 448.
\item Borenstein, M., Hedges, L. V., Higgins, J. P. T., & Rothstein, H. R. (2009). Converting among effect sizes. Introduction to meta-analysis, 45-49.
}
}
