% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtab.R
\name{phi}
\alias{phi}
\alias{cohens_w}
\alias{cramers_v}
\alias{oddsratio}
\alias{riskratio}
\alias{cohens_g}
\title{Effect size for contingency tables}
\usage{
phi(x, y = NULL, ci = 0.95, adjust = FALSE, CI, ...)

cohens_w(x, y = NULL, ci = 0.95, adjust = FALSE, CI, ...)

cramers_v(x, y = NULL, ci = 0.95, adjust = FALSE, CI, ...)

oddsratio(x, y = NULL, ci = 0.95, log = FALSE, ...)

riskratio(x, y = NULL, ci = 0.95, log = FALSE, ...)

cohens_g(x, y = NULL, ci = 0.95, ...)
}
\arguments{
\item{x}{a numeric vector or matrix. \code{x} and \code{y} can also
    both be factors.}

\item{y}{a numeric vector; ignored if \code{x} is a matrix.  If
    \code{x} is a factor, \code{y} should be a factor of the same length.}

\item{ci}{Confidence Interval (CI) level}

\item{adjust}{Should the effect size be bias-corrected? Defaults to \code{FALSE}.}

\item{CI}{Deprecated in favor of \code{ci}.}

\item{...}{Arguments passed to \code{\link[stats:chisq.test]{stats::chisq.test()}}, such as \code{p}. Ignored
for \code{cohens_g()}.}

\item{log}{Take in or output the log of the ratio (such as in logistic models).}
}
\value{
A data frame with the effect size(s), and confidence interval(s).
}
\description{
Compute Cramer's \emph{V}, phi (\eqn{\phi}), Cohen's \emph{w} (an alias of phi), Odds
ratios, Risk ratios and Cohen's \emph{g} for contingency tables or
goodness-of-fit. See details.
}
\details{
Cramer's \emph{V} and phi (\eqn{\phi}) are effect sizes for tests of independence
in 2D contingency tables, or for goodness-of-fit in 1D tables. For 2-by-2
tables, they are identical, and are equal to the simple correlation between
two dichotomous variables, ranging between  0 (no dependence) and 1 (perfect
dependence). For larger tables, Cramer's \emph{V} should be used, as it is bounded
between 0-1, whereas phi can be larger than 1.
\cr\cr
For 2-by-2 contingency tables, Odds ratios and Risk ratios can also be
estimated. Note that these are computed with each \strong{column} representing the
different groups, and the first column representing the baseline (or
control). If you wish you use rows as groups you must pass a transposed
table, or switch the \code{x} and \code{y} arguments.
\cr\cr
Cohen's \emph{g} is an effect size for dependent (paired) contingency tables
ranging between 0 (perfect symmetry) and 0.5 (perfect asymmetry) (see
\code{\link[stats:mcnemar.test]{stats::mcnemar.test()}}).
}
\section{Confidence Intervals for g, OR and RR}{
For Cohen's \emph{g}, confidence intervals are based on the proportion (\eqn{P = g
+ 0.5}) confidence intervals returned by \code{\link[stats:prop.test]{stats::prop.test()}} (minus 0.5),
which give a good close approximation.
\cr\cr
For Odds ratios and Risk ratios, confidence intervals are estimated using the
standard parametric method (see Katz et al., 1978; Szumilas, 2010).
\cr\cr
See \emph{Confidence Intervals} and \emph{CI Contains Zero} sections for \emph{phi}, Cohen's
\emph{w} and Cramer's \emph{V}.
}

\section{Confidence Intervals}{
Confidence intervals are estimated using the Noncentrality parameter method;
These methods searches for a the best non-central parameters (\code{ncp}s) of the
noncentral t-, F- or Chi-squared distribution for the desired
tail-probabilities, and then convert these \code{ncp}s to the corresponding effect
sizes.
}

\section{CI Contains Zero}{

Special care should be taken when interpreting CIs with a lower bound equal
to (or small then) 0, and even more care should be taken when the \emph{upper}
bound is equal to (or small then) 0 (Steiger, 2004; Morey et al., 2016).
}

\examples{
M <- rbind(
  c(150, 130, 35, 55),
  c(100, 50, 10, 40),
  c(165, 65, 2, 25)
)
dimnames(M) <- list(
  Study = c("Psych", "Econ", "Law"),
  Music = c("Pop", "Rock", "Jazz", "Classic")
)
M

phi(M)

cramers_v(M)



## 2-by-2 tables
## -------------
RCT <- rbind(
  c(30, 71),
  c(100, 50)
)
dimnames(RCT) <- list(
  Diagnosis = c("Sick", "Recovered"),
  Group = c("Control", "Treatment")
)
RCT # note groups are COLUMNS

oddsratio(RCT)

riskratio(RCT)



## Dependent (Paired) Contingency Tables
## -------------------------------------
Performance <- rbind(
  c(794, 86),
  c(150, 570)
)
dimnames(Performance) <- list(
  "1st Survey" = c("Approve", "Disapprove"),
  "2nd Survey" = c("Approve", "Disapprove")
)
Performance

cohens_g(Performance)
}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioural sciences.
\item Katz, D. J. S. M., Baptista, J., Azen, S. P., & Pike, M. C. (1978). Obtaining confidence intervals for the risk ratio in cohort studies. Biometrics, 469-474.
\item Szumilas, M. (2010). Explaining odds ratios. Journal of the Canadian academy of child and adolescent psychiatry, 19(3), 227.
}
}
\seealso{
\code{\link[=chisq_to_phi]{chisq_to_phi()}} for details regarding estimation and CIs.

Other effect size indices: 
\code{\link{cohens_d}()},
\code{\link{effectsize}()},
\code{\link{eta_squared}()},
\code{\link{standardize_parameters}()}
}
\concept{effect size indices}
